<?php
namespace addie\sql;

 /* 
            _     _ _   __               _ 
           | |   | (_)  \ \             | |
   __ _  __| | __| |_  __\ \   ___  __ _| |
  / _` |/ _` |/ _` | |/ _ \ \ / __|/ _` | |
 | (_| | (_| | (_| | |  __/\ \\__ | (_| | |
  \__,_|\__,_|\__,_|_|\___| \_|___/\__, |_|
                                      | |  
                                      |_|  

 *  What? MySQL Class for the Addie Framework by HTG
 *  Who? Created by Don Hawkins
 *  When? Finished and started 9/28/2016 while baby cleaned the kitchen.
 */
 
        ### Sql Class (extends database)
        class database {
       
            public function __construct($db_host,$db_username,$db_password,$db_database) {
                $this->db_host = $db_host;
                $this->db_username = $db_username;
                $this->db_password = $db_password;
                $this->db_database = $db_database;
            }

        public $table;
		public $where;
		public $limit;
		public $update_field;
		public $update_value;
		public $fields;
		public $values;
        public $link;


            //connect - Connect to the specified database automatically when this class is called (happens in a specific function)
            private function connect() {
            $link = mysqli_connect("$this->db_host", "$this->db_username", "$this->db_password", "$this->db_database");
			if (!$link) { throw new Exception('Unable to connect to the database:'. mysqli_connect_errno()); };	
            mysqli_set_charset($link,"utf8");  // Change character set to utf8
			return $link;
            }

            //disconnect - Closes a previously open database connection thereby freeing up resources
            private function disconnect($link) {
                
                //print_r($link);
                if (mysqli_close($link) === true) { return true; }else{ return false; }; 
                
            }
            
            //Added after someone hacked Teleoh and placed calls by adding these characters to their username/mysql query.
            private function check_invalid($string) {
               if (strpos($string, "'or'") !== false) { throw new Exception('Hacking Attempt'); }
               if (strpos($string, "'or''='") !== false) { throw new Exception('Hacking Attempt'); }
               if (strpos($string, "0' or 2 LIKE 2#") !== false) { throw new Exception('Hacking Attempt'); }
               if (strpos($string, "hi' or 'a'='a") !== false) { throw new Exception('Hacking Attempt'); }
               //if (strpos($string, "''") !== false) { throw new Exception('Hacking Attempt'); } 
               //100'or'3=3--
            }	
            
            //Generates a unique UUID which we store when we don't want to publicly share the auto increment ID.
            private function uuid(){
                    $data = random_bytes(16);
                    $data[6] = chr(ord($data[6]) & 0x0f | 0x40); 
                    $data[8] = chr(ord($data[8]) & 0x3f | 0x80); 
                    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
            }


		   ### Start functions inside of database class
		    

		       //// select - Single select
               public function select($table,$where) {
               
               try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }

               try { 

               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

               //// Loops through the $where and mysqli escapes invalid characters.
               $content = "/'(.*?)'/"; 
               preg_match_all($content, $where, $text); 
               //print_r($text);
               foreach ($text[1] as $replace) {
	           //echo $replace;
	            $new_replace = mysqli_real_escape_string($connection,$replace);
               $where = str_replace($replace,$new_replace,$where);
               }
               ////
  
  //             $newwhere = mysqli_real_escape_string($where);
//               echo $newwhere;

               $sql = "SELECT * FROM $table WHERE $where LIMIT 1";

               $data = mysqli_query($connection,$sql); 
			   $results = mysqli_fetch_assoc($data);
			   if (mysqli_error($connection)) { throw new Exception('Select Failed:'. mysqli_error($connection)); };
			   $final_results = (object) $results;
               $this->disconnect($connection); //Close connection on successful query
               return $final_results;
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection);	
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => "$e"
               );
               $final_results = (object) $error;
               $this->disconnect($connection); //Close connection on failed query
			   return $final_results;
               }
			} 
			

            
		       //// selectloop - Select which returns multiple rows
               public function selectloop($table,$where,$limit) {
               
			   if (!isset($where)) { throw new Exception('WHERE clause must be set.'); };
			   if (!isset($limit)) { throw new Exception('LIMIT must be set to a numeric limit.'); };
	         try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }		   			   			   	
             try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

               $sql = "SELECT * FROM $table WHERE $where LIMIT $limit";
               $data = mysqli_query($connection,$sql); 

			   if (mysqli_error($connection)) { throw new Exception('Select Loop Failed:'. mysqli_error($connection)); };
			   
			        //While Loop
			   $results = array();
               while($row = mysqli_fetch_object($data)) {
               $results[] = $row;
			   }
			   
			   $final_results = (object) $results;
               $this->disconnect($connection); //Close connection on successful query
               return $final_results;
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection);	
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => "$e"
               );
               $final_results = (object) $error;
               $this->disconnect($connection); //Close connection on failed query
			   return $final_results;
               }
			} 



             //// selectloop_offset - Select which returns multiple rows PLUS the ability to specify offset, great for pagnation.
               public function selectloop_offset($table,$where,$limit,$offset) {
               
            if (!isset($where)) { throw new Exception('WHERE clause must be set.'); };
            if (!isset($limit)) { throw new Exception('LIMIT must be set to a numeric limit.'); };
            if (!isset($offset)) { throw new Exception('OFFSET must be set to a numeric offset.'); };
            try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }                                   
             try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

               $sql = "SELECT * FROM $table WHERE $where LIMIT $limit OFFSET $offset";
               $data = mysqli_query($connection,$sql); 

            if (mysqli_error($connection)) { throw new Exception('Select Loop Failed:'. mysqli_error($connection)); };
            
                 //While Loop
            $results = array();
               while($row = mysqli_fetch_object($data)) {
               $results[] = $row;
            }
            
            $final_results = (object) $results;
               return $final_results;
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection); 
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => "$e"
               );
               $final_results = (object) $error;
            return $final_results;
               }
         } 


             //// selectmax - Single max or minimum value from a column
               public function selectmax($table,$where,$field,$maxormin) {
               	
               try { 
               $connection = $this->connect(); //Connect to the database using our private function.

               //// Loops through the $where and mysqli escapes invalid characters.
               $content = "/'(.*?)'/"; 
               preg_match_all($content, $where, $text); 
               //print_r($text);
               foreach ($text[1] as $replace) {
	           //echo $replace;
	           $new_replace = mysqli_real_escape_string($connection,$replace);
               $where = str_replace($replace,$new_replace,$where);	 
               //echo $where;
               }
               ////
               
               $sql = "SELECT $maxormin($field) as value FROM $table WHERE $where";
               $data = mysqli_query($connection,$sql); 
			   $results = mysqli_fetch_assoc($data);
			   if (mysqli_error($connection)) { throw new Exception('Select Failed:'. mysqli_error($connection)); };
			   $final_results = (object) $results;
               $this->disconnect($connection); //Close connection on successful query
               return $final_results;
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection);	
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => "$e"
               );
               $final_results = (object) $error;
               $this->disconnect($connection); //Close connection on failed query
			   return $final_results;
               }
			} 
           
            
            //// selectdistinct - Select distinct
           public function selectdistinct($table,$where,$distinct_field,$limit) {
               
         if (!isset($where)) { throw new Exception('WHERE clause must be set.'); };
         if (!isset($limit)) { throw new Exception('LIMIT must be set to a numeric limit.'); };
         try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }

               try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

               $sql = "SELECT distinct $distinct_field FROM $table WHERE $where LIMIT $limit";
               //$sql = mysqli_real_escape_string($sql); 
               $data = mysqli_query($connection,$sql); 

         if (mysqli_error($connection)) { throw new Exception('Select Loop Failed:'. mysqli_error($connection)); };
         
              //While Loop
         $results = array();
               while($row = mysqli_fetch_object($data)) {
               $results[] = $row;
         }
         
         $final_results = (object) $results;
         $this->disconnect($connection); //Close connection on successful query
               return $final_results;
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection); 
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => "$e"
               );
               $final_results = (object) $error;
               $this->disconnect($connection); //Close connection on failed query
         return $final_results;
               }
      } 


		       //// update - Update a single or multiple rows in a table
               public function update($table,$where,$update_field,$update_value) {
               	
  			   if (!isset($where)) { throw new Exception('WHERE clause must be set.'); };
               try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }

               try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

                 //If there is  UUID specified in the insert then replace it with a actual UUID
                 if ($update_value == '*UUID*' || $update_value == '*uuid*') { 
                     	if ($update_value != "0" && $update_value != "0.00") { 
                            $update_value = $this->uuid();
                         }
                  }
                      
               $sql = "UPDATE $table SET $update_field ='$update_value' WHERE $where";
               //$sql = mysqli_real_escape_string($sql); 
               $data = mysqli_query($connection,$sql); 
			   if (mysqli_error($connection)) { throw new Exception('Update Failed:'. mysqli_error($connection)); };
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection);	
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => "$e"
               );
               $this->disconnect($connection); //Close connection on success OR fail
               $final_results = (object) $error;
			   return $final_results;
               }
			} 


		       //// insert - Insert a new row
               public function insert($table,$fields,$values,$seperator) {
               
                   $new_uuid = '';
            
                   if ($seperator == "") { $seperator = "||"; }	//Default seperator for values is ||, you can provide anything you want though if there is conflicts.
               $all_values = '';
			   
			       if (!isset($fields)) { throw new Exception('Insert fields must be specified'); };
			       if (!isset($values)) { throw new Exception('Insert values must be specified'); };
                   //try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }			   

               try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

              //Explode values to wrap them in ' and escape invalid characters.
              $exploded_values = explode($seperator,$values);
              $uuid_count = 0;
                   
              foreach ($exploded_values as $temp) {
              $new_temp = mysqli_real_escape_string($connection,$temp);
                  
                  //If there is  UUID specified in the insert
                  if ($temp == '*UUID*' || $temp == '*uuid*') { 
                      
                      if ($temp != "0" && $temp != "0.00") { 
                          $new_temp = $this->uuid();
                          $new_uuid = $new_temp;
                          $uuid_count++;
                      }
                  }
	          
              $new_value = "'" . $new_temp . "'" . ',';
              $all_values = $all_values . $new_value;
    
              }
              if ($uuid_count > 1) { throw new Exception('Only one UUID allowed per insert.'); }
                   
			  $all_values = rtrim($all_values, ","); //Remove last comma

               $sql = "INSERT IGNORE INTO $table($fields) values ($all_values)";
               //$sql = mysqli_real_escape_string($sql); 
               $data = mysqli_query($connection,$sql); 
			   $newid = mysqli_insert_id($connection);
			   if (mysqli_error($connection)) { throw new Exception('Insert Failed:'. mysqli_error($connection)); };			   
			   if ($newid == '') { throw new Exception('New insert ID not present so insert failed.'. mysqli_error($connection)); };

               $results = array (
               "id"  => "$newid"
               );

               if ($new_uuid != '') { $results['UUID'] = $new_uuid; } //Add the UUID to the returned value.
			   
               $final_results = (object) $results;
               $this->disconnect($connection); //Close connection on successful query (added 1/20/2023)
			   return $final_results;
			   } catch(Exception $e) {
               if (mysqli_error($connection) != false) { $error_no = mysqli_errno($connection); }
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => $e->getMessage()
               );
               $final_results = (object) $error;
			   return $final_results;
               }
			} 
			   			   			

		       //// count - Get the number of rows that match our query.
               public function count($table,$where) {
               	
  			   if (!isset($where)) { throw new Exception('WHERE clause must be set.'); };
			   if (!isset($table)) { throw new Exception('Specify the name of the TABLE to count from.'); };
            try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }

               try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8
               
               $sql = "SELECT count(*) FROM $table WHERE $where";
	           $data = mysqli_query($connection,$sql);
               $row = mysqli_fetch_row($data);
               $num = $row[0];

			   if (mysqli_error($connection)) { throw new Exception('Count Failed:'. mysqli_error($connection)); };
			   
			   $result = new \stdClass();
               $result->count = $num;
			   
			   $final_results = (object) $result;
               $this->disconnect($connection); //Close connection on successful query
			   return $final_results;

			   } catch(Exception $e) {
               $error_no = mysqli_errno($connection);	
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => $e->getMessage()
               );
               $final_results = (object) $error;
               $this->disconnect($connection); //Close connection on failed query
			   return $final_results;
               }
			} 
			   

		       //// count_unique_field - Get the number of rows that match our query.
               public function count_unique_field($table,$unique_field,$where) {
               
               if (!isset($table)) { throw new Exception('Specify the name of the TABLE to count from.'); };
			   if (!isset($where)) { throw new Exception('WHERE clause must be set.'); };
  			   if (!isset($unique_field)) { throw new Exception('unique_field must be provided.'); };
	         try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }		   			   			   	
             try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

               $sql = "SELECT $unique_field,COUNT(*) AS COUNT FROM $table WHERE $where";
               $data = mysqli_query($connection,$sql); 

			   if (mysqli_error($connection)) { throw new Exception('Select Loop Failed:'. mysqli_error($connection)); };
			   
			        //While Loop
			   $results = array();
               while($row = mysqli_fetch_object($data)) {
               $results[] = $row;
			   }
			   
			   $final_results = (object) $results;
               $this->disconnect($connection); //Close connection on successful query
               return $final_results;
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection);	
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => "$e"
               );
               $final_results = (object) $error;
               $this->disconnect($connection); //Close connection on failed query
			   return $final_results;
               }
			} 


		       //// delete - Delete a row
               public function delete($table,$where) {
               	
  			   if (!isset($where)) { throw new Exception('WHERE clause must be set.'); };
			   if (!isset($table)) { throw new Exception('Specify the name of the TABLE to delete from.'); };
            try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }

               try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

               $sql = "DELETE FROM $table WHERE $where";
               //$sql = mysqli_real_escape_string($sql); 
               $data = mysqli_query($connection,$sql); 
			   if (mysqli_error($connection)) { throw new Exception('Delete Failed:'. mysqli_error($connection)); };
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection);	
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => $e->getMessage()
               );
               $final_results = (object) $error;
			   return $final_results;
               }
			} 
			   


           //// truncate - Truncate a table (empty)
               public function truncate($table) {
                
               if (!isset($table)) { throw new Exception('Specify the name of the TABLE to truncate.'); };
               
               try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

               $sql = "TRUNCATE $table";
               //$sql = mysqli_real_escape_string($sql); 
               $data = mysqli_query($connection,$sql); 
         if (mysqli_error($connection)) { throw new Exception('Delete Failed:'. mysqli_error($connection)); };
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection); 
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => $e->getMessage()
               );
               $final_results = (object) $error;
         return $final_results;
               }
      } 


		       //// sum - Sum rows (add them up)
               public function sum($table,$where,$field_to_sum) {
               
			   if (!isset($where)) { throw new Exception('WHERE clause must be set.'); };
			   if (!isset($field_to_sum)) { throw new Exception('field_to_sum must be set to the field you wish to sum.'); };
            try { $this->check_invalid($where); } catch(Exception $e) { throw new Exception($e->getMessage()); }			   			   			   	
               try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               mysqli_set_charset($connection,"utf8");  // Change character set to utf8

			   $sql = "SELECT IFNULL(IFNULL(SUM($field_to_sum), 0), 0) AS total FROM $table WHERE $where";
               $data = mysqli_query($connection,$sql); 

			   if (mysqli_error($connection)) { throw new Exception('Select Sum Failed:'. mysqli_error($connection)); };
			   
               $row = mysqli_fetch_assoc($data); 
               $num = $row['total'];
			   
			   $result = new \stdClass();
               $result->total = $num;
			   
			   $final_results = (object) $result;
               $this->disconnect($connection); //Close connection on successful query
			   return $final_results;

               } catch(Exception $e) {
               $error_no = mysqli_errno($connection);	
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => $e->getMessage()
               );
               $final_results = (object) $error;
               $this->disconnect($connection); //Close connection on failed query
			   return $final_results;
               }
			} 

		       //// avgerage - Average a row's values
               public function average($table,$field,$where) {
               	
  			   if (!isset($where)) { throw new Exception('WHERE clause must be set.'); };
			   if (!isset($table)) { throw new Exception('Specify the name of the TABLE to delete from.'); };
               if (!isset($field)) { throw new Exception('field to average must be provided.'); };
               
               try { 
               $connection = $this->connect(); //Connect to the database using our private function.
               $sql = "SELECT AVG($field) FROM (SELECT $field FROM $table WHERE $where) sub";
               $data = mysqli_query($connection,$sql); 
			   if (mysqli_error($connection)) { throw new Exception('Average Failed:'. mysqli_error($connection)); };
                   
                $row = mysqli_fetch_assoc($data);

               $num = $row["AVG($field)"];
			   $result = new \stdClass();
               $result->AVG = $num;
                  
			   $final_results = (object) $result;
               $this->disconnect($connection); //Close connection on successful query
			   return $final_results;
                   
               } catch(Exception $e) {
               $error_no = mysqli_errno($connection);	
               $error = array (
               "error_no"  => "$error_no",
               "error_msg" => $e->getMessage()
               );
               $final_results = (object) $error;
			   return $final_results;
               }
			} 
			   			  	
	   }
/*
 * Example code for all functions:
 * 
 * include '/home/heg/public_html/class.sql.php';


Error checking on any function:
if ($r->error_msg != "") { print "Query Failed"; }else{ print "Query Success"; }


//Connect to the database (should come before any query)
$sql = new database('heg');

   
//sum - Sum rows (table,where,field to sum) Returns $r->total;
$r = $sql->sum('BillingTransactions',"ID != ''",'COST');
 
 
//select - Single row select (limit 1) (table,where)
$r = $sql->select('UserAccounts',"ID = '53'");


//selectloop - Looped select with limit specifier (table,where,limit)
$r = $sql->selectloop('UserAccounts',"ID != ''",'5');
print_r($r);

   //Example looping through selectloop results:
   foreach ($r as $row) {
   echo $row->FIRST_NAME;	
   }



//selectdistinct - Looped distinct select with limit specifier (table,where,distinct field,limit)
$r = $sql->selectdistinct('UserAccounts',"ID != ''",'distinct_field','5');
print_r($r);

   //Example looping through selectloop results:
   foreach ($r as $row) {
   echo $row->FIRST_NAME; 
   }

   
//update - Update a row (table,where,update_field,update_value). If $r->error_msg is empty then it was a success.
$r = $sql->update('UserAccounts',"ID != '53'",'API_KEY','');
print_r($r);



//insert - Insert a row (table,fields,values). $r->id and $r->UUID if a UUID is in the insert call. Insert a UUID by supplying *UUID* as a value.
 * Seperator changed to double hockey sticks because of comma problem ||. Provide the last value to use any seperator uou want if there is conflicts.
$r = $sql->insert('UserAccounts',"ACCOUNT_NUMBER,COMPANY,FIRST_NAME,LAST_NAME","5488||SummerBooty||Chad Hawkins||Fuck Off",'||');
print_r($r);



//count - Count the number of rows. Returns $r->count;
$r = $sql->count('UserAccounts',"ID != ''");
print_r($r);



//delete - Delete a row (table,where). If $r->error_msg is empty then it was a success.
$r = $sql->delete('UserAccounts',"ID = '101'");
print_r($r);
 * 
*/
?>