# addie/payment/gateway

Process payments with supported gateways including Authorize.net, Stripe, and Helcim. Bank account (ACH) is supported for Authorize.net.

## Installation

```bash
composer require hawkinstg/addie
```

## Usage

```php
use addie\payment\gateways;

## Authentication

      # Authenticate with Stripe (Secret Key)
      $pay = new gateways('sk_live_YlXQeer34t43g4454g5g','','','live');

      # Authenticate with Authorize.net (Login ID, Key)
      $pay = new gateways('9h5nXD74d','49gZ465e44332fff','','live');


# authCharge - Collect a debit/credit card payment or authorization
$data = array(
  'customer' => array(
    'companyName' => 'Hawkins',
    'firstName' => 'JOHN',
    'lastName' => 'HAWKINS',
    'address' => '123 Main St',
    'address2' => '',
    'city' => 'DALLAS',
    'stateProvince' => 'TX',
    'postalCode' => '75221',
    'country' => 'USA',
    'phoneNumber' => '2145551212'
  ),
  'cardInfo' => array(
    'cardNumber' => '5441254785471114',
    'cardExpMonth' => '01',
    'cardExpYear' => '23',
    'cardCVV' => '123'
  ),
  'bankInfo' => array(
    'accountType' => '', //Options are Business Checking, Personal Checking, Business Savings, Personal Savings
    'accountNumber' => '',
    'routingNumber' => ''
  ),
  'referenceNumber' => '', //For gateways that support rerence numbers.
  'descriptor' => '' //For gateways that support custom descriptors.
);

//gateway,(auth or charge),amount,(CC or BA),data array
try { $trans = $pay->authcharge('authorize.net','auth','52.36','CC',$data); print_r($m); } catch (Exception $e) { $error = $e->getMessage(); echo 'Processing Error' . $error; }

## Capture a previously authorized 'auth' transaction.
try { $capture = $pay->captureAuthorization('stripe',$transactionId,'1.00','CC',$data); print_r($capture); } catch (Exception $e) { $error = $e->getMessage(); echo 'Capture Error : ' . $error; }

## Get details / check the status of an existing transaction.
try { $status = $pay->getTransaction('authorize.net',$transactionId); print_r($status); } catch (Exception $e) { $error = $e->getMessage(); echo 'Get Transaction Error : ' . $error; }

# Example Stripe Response for 'authCharge'
$trans->id; //Charge ID from Stripe
$trans->card->id; //The card_id
$trans->captured; (1 for yes, returned on both charge and capture)

```

## Contributing

Pull requests are welcome. For major changes, please open an issue first
to discuss what you would like to change.

Please make sure to update tests as appropriate.

## License

[MIT](https://choosealicense.com/licenses/mit/)