<?php
namespace addie\payment;
use addie\http\request;
/*
           _     _ _         __                                      _          __          _                               
  __ _  __| | __| (_) ___   / / __   __ _ _   _ _ __ ___   ___ _ __ | |_ ___   / /_ _  __ _| |_ _____      ____ _ _   _ ___ 
 / _` |/ _` |/ _` | |/ _ \ / / '_ \ / _` | | | | '_ ` _ \ / _ \ '_ \| __/ __| / / _` |/ _` | __/ _ \ \ /\ / / _` | | | / __|
| (_| | (_| | (_| | |  __// /| |_) | (_| | |_| | | | | | |  __/ | | | |_\__ \/ / (_| | (_| | ||  __/\ V  V / (_| | |_| \__ \
 \__,_|\__,_|\__,_|_|\___/_/ | .__/ \__,_|\__, |_| |_| |_|\___|_| |_|\__|___/_/ \__, |\__,_|\__\___| \_/\_/ \__,_|\__, |___/
                             |_|          |___/                                 |___/                             |___/     
*/

class gateways {
	
	//Assign the gateway name to use.
	public $api_secret1;
	public $api_secret2;
	public $api_secret3;
	public $mode;	
	public $chargeId;
	public $transactionId;

    // Assign the values
    public function __construct($api_secret1,$api_secret2,$api_secret3,$mode) {
    $this->api_secret1 = $api_secret1;
	$this->api_secret2 = $api_secret2;
	$this->api_secret3 = $api_secret3;
	$this->mode = $mode;	
	if ($mode == 'test' || $mode == 'live') { }else{ throw new \Exception("'Mode' must be 'test' or 'live'.", 1); };
    }

	/* 
	authCharge - Charge or authorize a card using one of the specified gateways.

		$paymentgateway = One of the supported gateways, authorize.net, etc.
		$transactionType = Either 'auth' or 'charge'
		$chargeInstrument = Either 'CC' or 'ACH'
		$amount = The amoutn to charge or authorize the card
		$data = An array of customer data and credit card inform

				$data = array(
					'customer' => array(
						'companyName' => '',
						'firstName' => '',
						'lastName' => '',
						'address' => '',
						'address2' => '',
						'city' => '',
						'stateProvince' => '',
						'postalCode' => '',
						'country' => '',
						'phoneNumber' => ''
					),
					'cardInfo' => array(
						'cardNumber' => '',
						'cardExpMonth' => '',
						'cardExpYear' => '',
						'cardCVV' => ''
					),
					'bankInfo' => array(
						'accountType' => '', //Options are Business Checking, Personal Checking, Business Savings, Personal Savings
						'accountNumber' => '',
						'routingNumber' => ''
					),
					'referenceNumber' => '', //For gateways that support rerence numbers.
					'descriptor' => '' //For gateways that support custom descriptors.
				);

	*/


	public function authCharge($paymentGateway,$transactionType,$amount,$chargeInstrument,$data) {

        if (!is_numeric($amount)) { throw new \Exception("A full dollar amount must be supplied for 'amount'."); };
        if (!strpos($amount,".") !== false){ throw new \Exception("A full dollar amount must be supplied for 'amount."); }; 
		if ($transactionType == 'auth' || $transactionType == 'charge') { }else{ throw new \Exception("'transactionType' must be either auth or charge.", 1); };
		if (strtoupper($chargeInstrument) == 'CC' || strtoupper($chargeInstrument) == 'ACH') { }else{ throw new \Exception("'chargeInstrument' must be CC or ACH.", 1); };

		if (!is_array($data)) {  throw new \Exception("'transactionType' must be auth or charge.", 1); }
		switch ($paymentGateway) {
			case 'authorize.net':
				if (strtoupper($chargeInstrument) == 'CC') { $r = $this->authorizenet_charge_cc($transactionType,$amount,$data); 
					$res = array("charge_id" => $r->transactionResponse->transId,"resultCode" => $r->messages->resultCode,"responseCode" => $r->transactionResponse->responseCode,"fullResponse" => $r);
					return $res; 
				}
				if (strtoupper($chargeInstrument) == 'BA') { $r = $this->authorizenet_charge_ba($amount,$data); 
					$res = array("charge_id" => $r->transactionResponse->transId,"resultCode" => $r->messages->resultCode,"responseCode" => $r->transactionResponse->responseCode,"fullResponse" => $r);
					return $res; 
				}
				break;
			case 'stripe':
				if (strtoupper($chargeInstrument) == 'CC') { $r = $this->stripe_charge_cc($transactionType,$amount,$data);
					$res = array("charge_id" => $r->id,"fullResponse" => $r);
					return $res; 
				}
				if (strtoupper($chargeInstrument) == 'BA') { throw new \Exception('Bank account is not currently supported on Stripe.'); }
				break;
			case 'helcim':
				if (strtoupper($chargeInstrument) == 'CC') { $r = $this->helcim_charge_cc($transactionType,$amount,$data); 
					$res = array("charge_id" => $r->transaction->transactionId,"fullResponse" => $r); //$captured = $r->response; //'1' if captured/successful
					return $res; 
				}
				if (strtoupper($chargeInstrument) == 'BA') { throw new \Exception('Bank account is not currently supported on Helcim.'); }
				break;

				throw new \Exception('Invalid gateway specified.');
		}

	}


	
	## captureAuthorization - Capture a charge that was previously authorized only '$transactionType = auth'. Using $data you can provide 'referenceNumber' only.
	public function captureAuthorization($paymentGateway,$transactionId,$amount,$data) {

        if (!is_numeric($amount)) { throw new \Exception("A full dollar amount must be supplied for 'amount'."); };
        if (!strpos($amount,".") !== false){ throw new \Exception("A full dollar amount must be supplied for 'amount'."); }; 
        if ($transactionId == ''){ throw new \Exception("Please provide a valid 'transactionId' to capture."); }; 

		switch ($paymentGateway) {
			case 'authorize.net':
				$r = $this->authorizenet_capture_cc($transactionId,$amount,$data); 
				$capture_res = array("charge_id" => $r->transactionResponse->transId,"resultCode" => $r->messages->resultCode,"responseCode" => $r->transactionResponse->responseCode,"fullResponse" => $r); //responseCode = '1' if captured/successful
				return $capture_res;
				break;
			case 'stripe':
				 $r = $this->stripe_capture_cc($transactionId);
				 $capture_res = array("charge_id" => $r->id,"resultCode" => $r->captured,"responseCode" => $r->captured,"fullResponse" => $r); //responseCode = '1' if captured/successful still
				 return $capture_res;
				 break;
			case 'helcim':
				$r = $this->helcim_capture_cc($transactionId);
				$capture_res = array("charge_id" => $r->transaction->transactionId,"resultCode" => $r->transactionResponse->responseCode,"responseCode" => $r->transactionResponse->responseCode,"fullResponse" => $r); //responseCode = '1' if captured/successful still
				return $capture_res;
				break;
			
				throw new \Exception('Invalid gateway specified for this function.');
		}

	}


	## getTransaction - Get a previously created transaction to check the status of it, etc.
	public function getTransaction($paymentGateway,$transactionId) {

        if ($transactionId == ''){ throw new \Exception("Please provide a valid 'transactionId' for the transaction you wish to retrieve."); }; 

		switch ($paymentGateway) {
			case 'authorize.net':
				$r = $this->authorizenet_transaction_status($transactionId); return $r;
				break;
			
				throw new \Exception('Invalid gateway specified for this function.');
		}

	}



## Private Functions Below



		// authorizenet_charge_cc - Authorize OR Charge a card with Authorize.net (last variable should be either auth or charge)
		private function authorizenet_charge_cc($transactionType,$amount,$data) {
	
		if ($transactionType == 'charge' || $transactionType == "auth") { }else{ throw new \Exception("'transactionType' must be 'charge' or 'auth'.", 1);   };
		if ($data['referenceNumber'] != '' && strlen($data['referenceNumber']) > 20) { throw new \Exception("Reference ID [referenceNumber] must be 20 characters or less.", 1); };	
		if ($transactionType == "auth") { $transactionTypeFiller = "authOnlyTransaction"; };
		if ($transactionType == "charge") { $transactionTypeFiller = "authCaptureTransaction";  };		
		if ($amount == '') { throw new \Exception("Provide the 'amount' to process."); }

		$cardNumber = $data['cardInfo']['cardNumber'];
		$cardExpMonth = $data['cardInfo']['cardExpMonth'];
		$cardExpYear = $data['cardInfo']['cardExpYear'];
		$cardCVV = $data['cardInfo']['cardCVV'];

		$companyName =  $data['customer']['companyName'];
		$firstName =  $data['customer']['firstName'];
		$lastName =  $data['customer']['lastName'];
		$address =  $data['customer']['address'];
		$address2 =  $data['customer']['address2'];
		$city =  $data['customer']['city'];
		$stateProvince =  $data['customer']['stateProvince'];
		$postalCode =  $data['customer']['postalCode'];
		$country =  $data['customer']['country'];
		$phoneNumber =  $data['customer']['phoneNumber'];


		$request_xml = "<createTransactionRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">
		<merchantAuthentication>
		<name>$this->api_secret1</name>
		<transactionKey>$this->api_secret2</transactionKey>
		</merchantAuthentication>
		<refId>$data[referenceNumber]</refId>
		<transactionRequest>
		<transactionType>$transactionTypeFiller</transactionType>
		<amount>$amount</amount>
		<payment>
		<creditCard>
		<cardNumber>$cardNumber</cardNumber>
		<expirationDate>$cardExpMonth$cardExpYear</expirationDate>
		<cardCode>$cardCVV</cardCode>
		</creditCard>
		</payment>
		<poNumber>$data[referenceNumber]</poNumber>
		<billTo>
		<firstName>$firstName</firstName>
		<lastName>$lastName</lastName>
		<company>$companyName</company>
		<address>$address</address>
		<city>$city</city>
		<state>$stateProvince</state>
		<zip>$postalCode</zip>
		<country>$country</country>
		</billTo>
		<transactionSettings>
		<setting>
		<settingName>testRequest</settingName>
		<settingValue>false</settingValue>
		</setting>
		</transactionSettings>
		</transactionRequest>
		</createTransactionRequest>";


		//Sent request to Authorize.net using the addie/http/request class.

		if ($this->mode == 'live') {  $url = 'https://api.authorize.net/xml/v1/request.api'; }else{ $url = 'https://apitest.authorize.net/xml/v1/request.api'; }

			$req = new request($url); 
			$req->setRawData($request_xml); 
			$req->request('POST'); 
			$body = $req->getBody(); 
			$res_xml = $req->decode('xml');

		if (!empty($res_xml->messages->message->text)) { throw new \Exception($res_xml->messages->message->text); }
		if (!empty($res_xml->transactionResponse->errors->error->errorText)) { throw new \Exception($res_xml->transactionResponse->errors->error->errorText); }
		if ($res_xml->messages->resultCode != 'Ok' || $res_xml->messages->resultCode == 'Error') { throw new \Exception($res_xml->messages->message->text, 1); };

		return $res_xml;

		}	

		# authorizenet_capture_cc - Capture a previously authorized charge on Authorize.net by passing the $transactionId and the $amount (should be equal to or less than the auth amount)
		private function authorizenet_capture_cc($transactionId,$amount,$data) {

			if ($data['referenceNumber'] != '' && strlen($data['referenceNumber']) > 20) { throw new \Exception("Reference ID [referenceNumber] must be 20 characters or less.", 1); };	

			$request_xml = "<createTransactionRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">
			<merchantAuthentication>
			<name>$this->api_secret1</name>
			<transactionKey>$this->api_secret2</transactionKey>
			</merchantAuthentication>
			<refId>$data[referenceNumber]</refId>
			<transactionRequest>
			<transactionType>priorAuthCaptureTransaction</transactionType>
			<amount>$amount</amount>
			<refTransId>$transactionId</refTransId>
			<order>
			</order>
			</transactionRequest>
			</createTransactionRequest>";

			if ($this->mode == 'live') {  $url = 'https://api.authorize.net/xml/v1/request.api'; }else{ $url = 'https://apitest.authorize.net/xml/v1/request.api'; }

				$req = new request($url); 
				$req->setRawData($request_xml); 
				$req->request('POST'); 
				$body = $req->getBody(); 
				$res_xml = $req->decode('xml');

				if ($res_xml->transactionResponse->messages->message->code == '311') { throw new \Exception("The transaction [$transactionId] has already been captured.", 1); };
				if (!empty($res_xml->messages->message->text)) { throw new \Exception($res_xml->messages->message->text); }
				if (!empty($res_xml->transactionResponse->errors->error->errorText)) { throw new \Exception($res_xml->transactionResponse->errors->error->errorText); }
				if ($res_xml->messages->resultCode != 'Ok' || $res_xml->messages->resultCode == 'Error') { throw new \Exception($res_xml->messages->message->text, 1); };

			return $res_xml;

		}

		// authorizenet_charge_ba - Authorize OR Charge a card with Authorize.net (last variable should be either auth or charge)
		private function authorizenet_charge_ba($amount,$data) {
	
			if ($data['referenceNumber'] != '' && strlen($data['referenceNumber']) > 20) { throw new \Exception("Reference ID [referenceNumber] must be 20 characters or less.", 1); };	
			if ($data['bankInfo']['accountNumber'] == '' || $data['bankInfo']['routingNumber'] == '') { throw new \Exception('accountNumber and routingNumber must be provided.',1); }
			if ($data['bankInfo']['accountType'] == 'Business Checking' || $data['bankInfo']['accountType'] == 'Personal Checking') { $account_type = 'checking'; }
			if ($data['bankInfo']['accountType'] == 'Business Savings' || $data['bankInfo']['accountType'] == 'Personal Savings') { $account_type = 'savings'; }

			if (str_contains($data['bankInfo']['accountType'] ,'Business') && $data['customer']['companyName'] == '') { throw new \Exception("Business accounts must have a 'companyName'"); } 
			if (str_contains($data['bankInfo']['accountType'] ,'Business')) { $account_name = $data['customer']['companyName']; }else{ $account_name = $data['customer']['firstName'] . ' ' . $data['customer']['lastName']; };
	
	
			$accountNumber = $data['bankInfo']['accountNumber'];
			$routingNumber = $data['bankInfo']['routingNumber'];
	
			$companyName =  $data['customer']['companyName'];
			$firstName =  $data['customer']['firstName'];
			$lastName =  $data['customer']['lastName'];
			$address =  $data['customer']['address'];
			$address2 =  $data['customer']['address2'];
			$city =  $data['customer']['city'];
			$stateProvince =  $data['customer']['stateProvince'];
			$postalCode =  $data['customer']['postalCode'];
			$country =  $data['customer']['country'];
			$phoneNumber =  $data['customer']['phoneNumber'];
	
	
			$request_xml = "<createTransactionRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">
			<merchantAuthentication>
			<name>$this->api_secret1</name>
			<transactionKey>$this->api_secret2</transactionKey>
			</merchantAuthentication>
			<refId>$data[referenceNumber]</refId>
			<transactionRequest>
			<transactionType>authCaptureTransaction</transactionType>
			<amount>$amount</amount>
			<payment>
		   <bankAccount>
			<accountType>$account_type</accountType>
			<routingNumber>$routingNumber</routingNumber>
			<accountNumber>$accountNumber</accountNumber>
			<nameOnAccount>$account_name</nameOnAccount>
		   </bankAccount>
			</payment>
			<poNumber>$data[referenceNumber]</poNumber>
		  <billTo>
			<firstName>$firstName</firstName>
			<lastName>$lastName</lastName>
			<company>$companyName</company>
			<address>$address</address>
			<city>$city</city>
			<state>$stateProvince</state>
			<zip>$postalCode</zip>
			<country>$country</country>
		  </billTo>
		  <transactionSettings>
			<setting>
			<settingName>testRequest</settingName>
			<settingValue>false</settingValue>
			</setting>
		 </transactionSettings>
			</transactionRequest>
			</createTransactionRequest>";
	
	
			//Sent request to Authorize.net using the addie/http/request class.
	
			if ($this->mode == 'live') {  $url = 'https://api.authorize.net/xml/v1/request.api'; }else{ $url = 'https://apitest.authorize.net/xml/v1/request.api'; }
	
				$req = new request($url); 
				$req->setRawData($request_xml); 
				$req->request('POST'); 
				$body = $req->getBody(); 
				$res_xml = $req->decode('xml');
	
			if (!empty($res_xml->messages->message->text)) { throw new \Exception($res_xml->messages->message->text); }
			if (!empty($res_xml->transactionResponse->errors->error->errorText)) { throw new \Exception($res_xml->transactionResponse->errors->error->errorText); }
			if ($res_xml->messages->resultCode != 'Ok' || $res_xml->messages->resultCode == 'Error') { throw new \Exception($res_xml->messages->message->text, 1); };
	
			return $res_xml;
	
			}	


		// stripe_charge - Authorize OR Charge a card with Stripe (last variable should be either auth or charge)
		private function stripe_charge_cc($transactionType,$amount,$data) {

			if ($transactionType == 'charge' || $transactionType == "auth") { }else{ throw new \Exception("'transactionType' must be 'charge' or 'auth'.", 1);   };
			if ($data['referenceNumber'] != '' && strlen($data['referenceNumber']) > 20) { throw new \Exception("Reference ID [referenceNumber] must be 20 characters or less.", 1); };	
			if ($transactionType == "charge") { $capture = "true"; }else{ $capture = "false"; };		
			if ($amount == '') { throw new \Exception("Provide the 'amount' to process."); }

			$cardNumber = $data['cardInfo']['cardNumber'];
			$cardExpMonth = $data['cardInfo']['cardExpMonth'];
			$cardExpYear = $data['cardInfo']['cardExpYear'];
			$cardCVV = $data['cardInfo']['cardCVV'];
	
			$companyName =  $data['customer']['companyName'];
			$firstName =  $data['customer']['firstName'];
			$lastName =  $data['customer']['lastName'];
			$address =  $data['customer']['address'];
			$address2 =  $data['customer']['address2'];
			$city =  $data['customer']['city'];
			$stateProvince =  $data['customer']['stateProvince'];
			$postalCode =  $data['customer']['postalCode'];
			$country =  $data['customer']['country'];
			$phoneNumber =  $data['customer']['phoneNumber'];
	
			   //Convert dollars to cents
			   $final_amount = $amount/0.01;
			   
					//Setup the card array 
					$card = array(
					'object' => "card",
					'number' => "$cardNumber",
					'exp_month' => "$cardExpMonth",
					'exp_year' => "$cardExpYear",
					'cvc' => "$cardCVV",
					'name' => "$firstName" . ' ' . "$lastName",
					'address_line1' => "$address",
					'address_line2' => "$address2",
					'address_city' => "$city",
					'address_zip' => "$postalCode",
					'address_state' => "$stateProvince",
					'address_country' => $country
					);
					
			## Stripe throws an error if descriptor is blank but the para is passed, this fixes that.
			if ($data['descriptor'] != '') { 
			//Setup the params with the descriptor
				$params = array(
					'source' => ($card),
					'amount' => ($final_amount),
					'currency' => ('USD'),
					'capture' => ($capture),
					'statement_descriptor' => ($data['descriptor'])
				);
			}else{
			//Setup the params without the descriptor
				$params = array(
					'source' => ($card),
					'amount' => ($final_amount),
					'currency' => ('USD'),
					'capture' => ($capture)
				);
			}
	
			//Sent request to Stripe using the addie/http/request class.
			if ($this->mode == 'live') {  $url = 'https://api.stripe.com/v1/charges'; }else{ $url = 'https://api.stripe.com/v1/charges'; }
	
				$req = new request($url); 
				$req->setHeader(array("Authorization: Bearer " . $this->api_secret1));
				$req->setParams($params);
				$req->request('POST'); 
				$res_json = $req->decode('json');
	
				//Check for error
				if (!empty($res_json->error->type) || !empty($res_json->error->message)) { throw new \Exception($res_json->error->type . ' ' . $res_json->error->message); };

			return $res_json;
	
			}	


		// stripe_capture_cc - Capture a previously authorized charge (just pass the $chargeID from the initial 'auth')
		private function stripe_capture_cc($chargeId) {

			if ($chargeId == '') { throw new \Exception("charge_id is required.", 1);  };
	
			//Sent request to Stripe using the addie/http/request class (NOTE: The $chargeId is in the url).
			if ($this->mode == 'live') {  $url = "https://api.stripe.com/v1/charges/$chargeId/capture"; }else{ $url = "https://api.stripe.com/v1/charges/$chargeId/capture"; }
	
				$req = new request($url); 
				$req->setHeader(array("Authorization: Bearer " . $this->api_secret1));
				$req->request('POST'); 
				$res_json = $req->decode('json');
	
				//Check for error
				if (!empty($res_json->error->type) || !empty($res_json->error->message)) { throw new \Exception($res_json->error->type . ' ' . $res_json->error->message); };

			return $res_json;
	
		}	


		## helcim_charge_cc - Charge or auth a card with Helcim
		private function helcim_charge_cc($transactionType,$amount,$data) {
               
			if ($transactionType == 'charge' || $transactionType == "auth") { }else{ throw new \Exception("'transactionType' must be 'charge' or 'auth'.", 1);   };
			if ($data['referenceNumber'] != '' && strlen($data['referenceNumber']) > 20) { throw new \Exception("Reference ID [referenceNumber] must be 20 characters or less.", 1); };	
			if ($transactionType == "charge") { $capture = "purchase"; }else{ $capture = "preauth"; };		
			if ($amount == '') { throw new \Exception("Provide the 'amount' to process."); }
		
			if ($this->mode == 'test') { $test_setting = '1'; } 
			
		   
				 //Setup the params that Helcim wants.
				 $params = array(
					'test' => "$test_setting",
					'accountId' => $this->api_secret1,
					'apiToken' => $this->api_secret2,
					'transactionType' => $capture,
					'cardHolderName' => $data['customer']['firstName'] . ' ' . $data['customer']['lastName'],
					'cardNumber' => $data['cardInfo']['cardNumber'],
					'cardExpiry' => $data['cardInfo']['cardExpMonth'] . $data['cardInfo']['cardExpYear'],
					'cardCVV' => $data['cardInfo']['cardCVV'],
					'cardHolderAddress' => $data['customer']['address'],
					'cardHolderPostalCode' => $data['customer']['postalCode'],
					'amount' => $amount
				 );
	 
			$req = new request('https://secure.myhelcim.com/api/'); 
			$req->setParams($params);
			$req->request('POST'); 
			$res_xml = $req->decode('xml');

			//Check for error and throw exception if needed.
			if (!empty($res_xml->error->type) || !empty($res_xml->error->message)) { throw new \Exception($res_xml->error->type . ' ' . $res_xml->error->message); };

			return $res_xml;

		}  	


		## helcim_capture_cc - Capture a previously authorized card
		private function helcim_capture_cc($transactionId) {

			if ($transactionId == '') { throw new \Exception("'transactionId' is required.", 1);  };
			if ($this->mode == 'test') { $test_setting = '1'; } 

			//Setup the card array 
			$params = array(
			'test' => "$test_setting",
			'transactionType' => 'capture',
			'accountId' => $this->api_secret1,
			'apiToken' => $this->api_secret2,
			'transactionId' => $transactionId
			 );

			$req = new request('https://secure.myhelcim.com/api/'); 
			$req->setParams($params);
			$req->request('POST'); 
			$res_xml = $req->decode('xml');

			//Check for error and throw exception if needed.
			if (!empty($res_xml->error->type) || !empty($res_xml->error->message)) { throw new \Exception($res_xml->error->type . ' ' . $res_xml->error->message); };

			return $res_xml;

	  }

		#  authorizenet_transaction_status - Get a previous transaction on authorize.net (works for card and bank account)
		private function authorizenet_transaction_status($transactionId) {

			$request_xml = "<getTransactionDetailsRequest xmlns=\"AnetApi/xml/v1/schema/AnetApiSchema.xsd\">
			<merchantAuthentication>
			<name>$this->api_secret1</name>
			<transactionKey>$this->api_secret2</transactionKey>
			</merchantAuthentication>
			<transId>$transactionId</transId>
			</getTransactionDetailsRequest>";


			if ($this->mode == 'live') {  $url = 'https://api.authorize.net/xml/v1/request.api'; }else{ $url = 'https://apitest.authorize.net/xml/v1/request.api'; }

				$req = new request($url); 
				$req->setRawData($request_xml); 
				$req->request('POST'); 
				$body = $req->getBody(); 
				$res_xml = $req->decode('xml');

				if (!empty($res_xml->messages->message->text)) { throw new \Exception($res_xml->messages->message->text); }
				if (!empty($res_xml->transactionResponse->errors->error->errorText)) { throw new \Exception($res_xml->transactionResponse->errors->error->errorText); }
				if ($res_xml->messages->resultCode != 'Ok' || $res_xml->messages->resultCode == 'Error') { throw new \Exception($res_xml->messages->message->text, 1); };

			return $res_xml;

		}

}

/*
use addie\payment\gateways;

$data = array(
  'customer' => array(
    'companyName' => 'Hawkins',
    'firstName' => 'JOHN',
    'lastName' => 'HAWKINS',
    'address' => '2922 WEATHER VANE LN',
    'address2' => '',
    'city' => 'DALLAS',
    'stateProvince' => 'TX',
    'postalCode' => '75228',
    'country' => 'USA',
    'phoneNumber' => '2145551212'
  ),
  'cardInfo' => array(
    'cardNumber' => '5425147856987423',
    'cardExpMonth' => '01',
    'cardExpYear' => '23',
    'cardCVV' => '123'
  ),
  'bankInfo' => array(
    'accountType' => '', //Options are Business Checking, Personal Checking, Business Savings, Personal Savings
    'accountNumber' => '',
    'routingNumber' => ''
  ),
  'referenceNumber' => '', //For gateways that support rerence numbers.
  'descriptor' => '' //For gateways that support custom descriptors.
);


$pay = new addie\payment\gateways('6h5nXDLD7y','49gZ465e4WTbHSdh','','test');

try { 
	$money = $pay->authcharge('authorize.net','auth','52.36','CC',$data); 

		$new_charge_id = $money['charge_id']; //Returned with all gateways if not error
		$resultCode = $money['resultCode];
		$responseCode = $money['responseCode'];

		//print_r($money);

} catch (Exception $e) { $error = $e->getMessage(); echo 'Gateway Error' . $error; }
*/
?>

