<?php
namespace addie\integrations;


//Initiate Request Client
use addie\http\request;

/*
            _     _ _   __     _       _                       _   _              __                        _ _               _       _     
           | |   | (_)  \ \   (_)     | |                     | | (_)             \ \                      | | |             | |     | |    
   __ _  __| | __| |_  __\ \   _ _ __ | |_ ___  __ _ _ __ __ _| |_ _  ___  _ __  __\ \   _ __ ___  ___  ___| | | ___ _ __ ___| |_   _| |__  
  / _` |/ _` |/ _` | |/ _ \ \ | | '_ \| __/ _ \/ _` | '__/ _` | __| |/ _ \| '_ \/ __\ \ | '__/ _ \/ __|/ _ \ | |/ _ \ '__/ __| | | | | '_ \ 
 | (_| | (_| | (_| | |  __/\ \| | | | | ||  __/ (_| | | | (_| | |_| | (_) | | | \__ \\ \| | |  __/\__ \  __/ | |  __/ | | (__| | |_| | |_) |
  \__,_|\__,_|\__,_|_|\___| \_\_|_| |_|\__\___|\__, |_|  \__,_|\__|_|\___/|_| |_|___/ \_\_|  \___||___/\___|_|_|\___|_|  \___|_|\__,_|_.__/ 
                                                __/ |                                                                                       
                                               |___/                                                                                        
Reseller ID: 139879
API Key : raAAY9xH9IubICFDuJiiKhcK3AnQiDaS
*/

class resellerclub {

public $authuserid;
public $apikey;
public $domain;
public $tlds;


    public function __construct($authuserid,$apikey) {
      $this->authuserid = $authuserid;
      $this->apikey = $apikey;
    }


    //Check domain availability (domain,tld)
    public function checkDomainAvailability($domain,$tld) {

        if(!preg_match("/^[_a-zA-Z0-9-]+$/", $domain)) { throw new \Exception('Invalid characters specified for domain name. Only letters, numbers, and dashes are allowed.'); }
        if ($tld == 'com' || $tld == 'net' || $tld == 'org' || $tld == 'co' || $tld == 'biz' || $tld == 'info' || $tld == 'us' || $tld == 'tel' || $tld == 'cloud' || $tld == 'xyz') {  }else{ throw new \Exception('Invalid domain TLD specified.');  };

        $req = new request('https://domaincheck.httpapi.com/api/domains/available.json');
        $req->setParams(array('auth-userid' => $this->authuserid,'api-key' => $this->apikey,'domain-name' => "$domain",'tlds' => $tld));
        $req->setProxy('http://35.232.164.25:80');
        $req->setProxyAuth('pxuser','(hVhMUC$TfLU+!yw');
        $req->request('GET'); //Sends the request

        if (!str_contains($req->getHeader(),'200')) { throw new \Exception('200 Response code not returned.'); }

        $res_obj = $req->decode('json');
        //$res_body = $req->getBody(); //Full response
        
        return $res_obj;
    }


    //Suggest available domains ($keyword, $tlds = specific tlds you may want to search for, optional, exactMatch = true or false)
    public function suggestDomainNames($keyword,$tlds,$exactMatch) {

      if(!preg_match("/^[_a-zA-Z0-9-]+$/", $keyword)) { throw new \Exception('Invalid characters specified for suggestible keyword. Only letters, numbers, and dashes are allowed.'); }

      $req = new request('https://test.httpapi.com/api/domains/v5/suggest-names.json');
      $req->setParams(array('auth-userid' => $this->authuserid,'api-key' => $this->apikey,'keyword' => "$keyword",'tld-only' => $tlds,"exact-match" => $exactMatch));
      $req->setProxy('http://35.232.164.25:80');
      $req->setProxyAuth('pxuser','(hVhMUC$TfLU+!yw');
      $req->request('GET'); //Sends the request

      if (!str_contains($req->getHeader(),'200')) { throw new \Exception('200 Response code not returned.'); }
        
      $res_obj = $req->decode('json');
      //$res_body = $req->getBody(); //Full response

      return $res_obj;
    }



} //end Class


/*

//Initialize
$rc = new resellerclub('139879','raAAY9xH9IubICFDuJiiKhcK3AnQiDaS'); //Reseller ID and API Key both available @ Settings>API

#### Check domain availability

  try { $results = $rc->checkDomainAvailability('domainyouwant','com'); } catch (Exception e) { $error = $e->getMessage(); echo $error; } //Domain name, TLD

  Response:
  stdClass Object
  (
    [mvno.com] => stdClass Object
        (
            [classkey] => domcno
            [status] => regthroughothers or [status] => available
        )

  )

#### Suggest domain names

  try { $results = $rc->suggestDomainNames('telecom','',false); } catch (Exception $e) { $error = $e->getMessage(); echo $error; } //Domain name, TLD
  print_r($results);

  Response:
  stdClass Object
  (
    [topglobaltelecom.com] => stdClass Object
        (
            [status] => available
            [in_ga] => true
            [score] => 0.68
            [spin] => yes
        )

*/

?>