# addie/storage/cloudstorage

A simple class for working with Google Cloud Storage

## Installation

Installed as part of the Addie framework from HTG

```bash
composer require hawkinstg/addie
```

## Usage

```php
use addie\storage\cloudstorage;

$storage = new cloudstorage('my_bucket_name',$_SERVER['DOCUMENT_ROOT'] . '/my_json_authentication_credentials.json');

# Check if a file exist (returns true or false)
try { $r = $storage->exists($filename);  } catch (Exception $e) { $error = $e->getMessage(); echo $error; }

# List all objects/files in a bucket
try { $r = $storage->listObjects(); print_r($r); } catch (Exception $e) { $error = $e->getMessage(); echo $error; }

# Upload a file to the bucket
try { $up = $storage->upload('mydoc.pdf',local\path\to\my\file.pdf'); } catch (Exception $e) { $error = $e->getMessage(); echo 'Upload Error : ' . $error; }
```

## License

[MIT](https://choosealicense.com/licenses/mit/)