<?
namespace addie\messaging;

//Initiate the Google PubSub Client 
use Google\Cloud\PubSub\PubSubClient;

/*
           _     _ _         __                                   _                __           _               _     
  __ _  __| | __| (_) ___   / / __ ___   ___  ___ ___  __ _  __ _(_)_ __   __ _   / / __  _   _| |__  ___ _   _| |__  
 / _` |/ _` |/ _` | |/ _ \ / / '_ ` _ \ / _ \/ __/ __|/ _` |/ _` | | '_ \ / _` | / / '_ \| | | | '_ \/ __| | | | '_ \ 
| (_| | (_| | (_| | |  __// /| | | | | |  __/\__ \__ \ (_| | (_| | | | | | (_| |/ /| |_) | |_| | |_) \__ \ |_| | |_) |
 \__,_|\__,_|\__,_|_|\___/_/ |_| |_| |_|\___||___/___/\__,_|\__, |_|_| |_|\__, /_/ | .__/ \__,_|_.__/|___/\__,_|_.__/ 
                                                            |___/         |___/    |_|                                
*/

        class pubsub {
        	
            // Creating the properties for a database connection.
            //public $db_host = '104.196.62.171'; Google
			public $app_credentials_path;
            public $topic;
            public $message;
			public $attributes;
            

            public function __construct($app_credentials_path) {

                if ($content = file_get_contents($app_credentials_path)) { //Google Application credentials, point to the file (doesn't have to be in this folder)
            
                //If the file is remote we need to download it to a local file.
                if (str_contains($app_credentials_path,'http://') || str_contains($app_credentials_path,'https://')) {

                    @mkdir('/tmp');
                    if (!file_exists('/tmp/google_cloud_storage_credentials.json')) { file_put_contents('/tmp/google_cloud_storage_credentials.json',$content); };
                    $app_credentials_path = '/tmp/google_cloud_storage_credentials.json';
                    $this->app_credentials_path = $app_credentials_path;

                }else{

                    if (file_exists($app_credentials_path)) { //Google Application credentials, point to the file (doesn't have to be in this folder)
                        putenv("GOOGLE_APPLICATION_CREDENTIALS=$app_credentials_path");
                    }else{
                    throw new \Exception('Unable to locate app credentials at the specified location.'); 
                    }

                }
            
                putenv("GOOGLE_APPLICATION_CREDENTIALS=$app_credentials_path");
                
                }else{
                throw new \Exception('Unable to locate app credentials at the specified url.'); 
                }

                $this->gcpubsub = new PubSubClient();
            }


            public function post($topic,$message,$attributes = array()) {

                // Get an instance of a previously created topic.
                $topic = $this->gcpubsub->topic($topic);

                // Publish a message to the topic.
                $topic->publish([
                'data' => $message,
                'attributes' => $attributes
                ]);

                return true;
            }

            public function getAllMessages($subscription_name) {

                $all_messages = array();
                $pre_messages = array();

                // Get an instance of a previously created subscription.
                $subscription = $this->gcpubsub->subscription($subscription_name);
                foreach ($subscription->pull() as $message) {

                    $pre_message = $message->data();
                    $all_messages[] = $pre_message;

                    // Acknowledge the Pub/Sub message has been received, so it will not be pulled multiple times.
                    $subscription->acknowledge($message);
                }

            return $all_messages;
           }


            public function receivePush($raw_post_data) {

                $attributes = array();
                $message = '';

                $decoded = json_decode($raw_post_data);
                foreach ($decoded->message->attributes as $key => $value) {
                    $attributes[] = array("$key" => $value);
                }
                
                $subscription_name = $decoded->subscription;
                if (!empty($decoded->message->data)) { $message = base64_decode($decoded->message->data); };
                $publish_time = $decoded->message->publishTime;
                
                $return_array = array ('time' => $publish_time,'subscription_name' => $subscription_name,'message' => $message,'attributes' => $attributes);

                return $return_array;
            }

}
/*

use addie\messaging\pubsub;
$ps = new pubsub($_SERVER['DOCUMENT_ROOT'] . '/XXXXXXX-5065d416efd5.json');

//Pull Messages

    try { $getAll = $ps->getAllMessages('projects/XXX/subscriptions/XXX'); } catch (Exception $e) { $error = $e->getMessage(); echo $error; }
    print_r($getAll);


//Post Message

    $attributes = array('foo' => 'bar');
    $message = "This is a pretend message that we are getting from Cloud Pub Sub.";

    try { $postmessage = $ps->post('projects/XXX/topics/XXX',$message,$attributes); } catch (Exception $e) { $error = $e->getMessage(); echo $error; }
    print_r($postmessage);


//Receive Push (should be placed in http receiver endpoint), returns array.

    $posted = file_get_contents('php://input');
    $return = $ps->receivePush($posted);
    $attributes = array_merge(...$return['attributes']); //The $attributes is returned as an array of arrays, this handy trick merges those into one simple array.

    //Example Return Example : $return_array = array ('time' => '2023-06-11 04:33:55Z','subscription_name' => 'projects/certain-purpose-376900/subscriptions/telecloud-push','attributes' => array);

*/
?>