<?php
namespace addie\messaging;

//Initiate the Google PubSub Client 
use addie\http\request;

/*
            _     _ _          __                                  _                 __                  _ _ 
           | |   | (_)        / /                                 (_)               / /                 (_) |
   __ _  __| | __| |_  ___   / / __ ___   ___  ___ ___  __ _  __ _ _ _ __   __ _   / /__ _ __ ___   __ _ _| |
  / _` |/ _` |/ _` | |/ _ \ / / '_ ` _ \ / _ \/ __/ __|/ _` |/ _` | | '_ \ / _` | / / _ \ '_ ` _ \ / _` | | |
 | (_| | (_| | (_| | |  __// /| | | | | |  __/\__ \__ \ (_| | (_| | | | | | (_| |/ /  __/ | | | | | (_| | | |
  \__,_|\__,_|\__,_|_|\___/_/ |_| |_| |_|\___||___/___/\__,_|\__, |_|_| |_|\__, /_/ \___|_| |_| |_|\__,_|_|_|
                                                              __/ |         __/ |                            
                                                             |___/         |___/                             
*/

class email {
        	
  public $carrier;
  public $apiKey;
  public $apiKeyFileLocation; 

  public function __construct($carrier,$apiKey,$apiKeyFileLocation) {

      $this->carrier = strtolower($carrier);
      $this->apiKeyFileLocation = $apiKeyFileLocation;

      if ($apiKey == '' && $apiKeyFileLocation = '') { throw new \Exception("Either 'apiKey' or 'apiKeyFilelocation' must be specified."); }
      if ($apiKey != '' && $apiKeyFileLocation != '') { throw new \Exception("Either 'apiKey' or 'apiKeyFilelocation' must be specified, not both."); }

      //Check if we are using a local or remote keyFileLocation
      if ($apiKeyFileLocation != '') { 
        if (str_contains($apiKeyFileLocation,'http')) {
          //Remote 'apiKeyFileLocation' file, get contents
          $r = new request($apiKeyFileLocation);
          $r->request('GET');
          $keyFileRes = $r->getBody(); //Full response
          if (trim($keyFileRes) == '') { throw new \Exception("No content returned by the key file."); };
        }else{
          //Local apiKeyFileLocation
          if (!file_exists($apiKeyFileLocation)) { throw new \Exception("Unable to locate app credentials at the specified local 'apiKeyFileLocation'");  } 
          $keyFileRes = file_get_contents($apiKeyFileLocation);
        }
      };

      //API key is specified so we just gonna use that / if not we use the key file response (should be a empty file with JUST the API key)
      if ($apiKey != '') { $this->apiKey = $apiKey; }else{ $this->apiKey = $keyFileRes; };

  }



  public function send($to_email,$from_email,$subject,$contents,$additional_parameters) {


    //Send with appropriate mail service
    switch ($this->carrier) {
			case 'mailgun':
          $sendmail_mailgun = $this->send_mailgun($to_email,$from_email,$subject,$contents,$additional_parameters);
          return $sendmail_mailgun;
          break;
      case 'sendgrid':
          $sendmail_sendgrid = $this->send_sendgrid($to_email,$from_email,$subject,$contents,$additional_parameters);
          return $sendmail_sendgrid;
        break;
			} 
			
     throw new \Exception("Invalid carrier $this->carrier specified.");

  }




/*
             _            _          __                  _   _                  ____  
  _ __  _ __(_)_   ____ _| |_ ___   / _|_   _ _ __   ___| |_(_) ___  _ __  ___  \ \ \ 
 | '_ \| '__| \ \ / / _` | __/ _ \ | |_| | | | '_ \ / __| __| |/ _ \| '_ \/ __|  \ \ \
 | |_) | |  | |\ V / (_| | ||  __/ |  _| |_| | | | | (__| |_| | (_) | | | \__ \  / / /
 | .__/|_|  |_| \_/ \__,_|\__\___| |_|  \__,_|_| |_|\___|\__|_|\___/|_| |_|___/ /_/_/ 
 |_|                                                                                  
 */

   private function send_mailgun($to,$from,$subject,$html,$additional_parameters) {

      /*
      Since this is mailgun, we're only looking in the additional_parameters['mailgun'] section which would be an array of params, example below:
      mailgun' => array("message_id" => '',"o:tracking-clicks" => 'yes',"o:tracking-opens" => 'yes',"o:tag" => '',"v:announcement_id" => '',"v:user_name" => '') 
      Accessible Like: $additional_parameters['mailgun']['v:user_name']
      */

      if ($additional_parameters['mailgun']['domain'] == '') { throw new \Exception("'domain' must be specified in the 'additional_parameters' in the 'mailgun' array."); };

      $primary_post_fields = array(
        'to' => $to,
        'from' => $from,
        'subject' => $subject,
        'h:Reply-To' => $additional_parameters['reply_to_email'],
        'html' => $html
        );
  

       //Combine anything provided in the $additional_parameters['mailgun'] with the primary post fields.
       $post_fields = array_merge_recursive($primary_post_fields,$additional_parameters['mailgun']);

       //Send request
       try {  
          $r = new request('https://api.mailgun.net/v3/' . $post_fields['domain'] . '/messages');
          $r->setAuthCreds('api',$this->apiKey);
          $r->setParams($post_fields);

          $r->request('POST');
          $decoded = $r->decode('json'); // Full response decoded.
          $res_body = $r->getBody(); //Full response
      } catch (\Exception $e) { $error = $e->getMessage(); throw new \Exception("Request : " . $error); }

       if ($decoded->error->code != '') { throw new \Exception("API Error:" . ' '. $decoded->error->code . ' ' . $decoded->error->message, 1); };

      //$messageid = $reply->{'id'};
      //$error = $reply->{'message'};

    return $decoded;
}



### SendGrid
private function send_sendgrid($to,$from,$subject,$html,$additional_parameters = array()){
               
  
       $auth_headers = array(
        "Authorization: Bearer $this->apiKey",
        "Accept: application/json",
        "Content-Type:application/json"
       ); 

$ch = curl_init();
$headers = [];
  
if ($additional_parameters['reply_to_email'] != '') { $reply_email = $additional_parameters['reply_to_email']; }else{  $reply_email = $from; };

if (is_array($additional_parameters) && $additional_parameters['bcc'] != '') {

$send_data = array (
 'personalizations' => 
 array (
   0 => 
   array (
     'to' => 
     array (
       0 => 
       array (
         'email' => $to,
         'subject' => $subject
       ),
     ),
     'bcc' => 
     array (
       0 => 
       array (
         'email' => $additional_parameters['bcc']
       ),
     ),
   ),
 ),
 'reply_to' => 
 array (
   'email' => $reply_email,
 ),
 'from' => 
 array (
   'email' => $from,
 ),
 'subject' => $subject,
 'content' => 
 array (
   0 => 
   array (
     'type' => 'text/html',
     'value' => $html,
   ),
 ),
);
}else{
$send_data = array (
 'personalizations' => 
 array (
   0 => 
   array (
     'to' => 
     array (
       0 => 
       array (
         'email' => $to,
         'subject' => $subject
       ),
     ),

   ),
 ),
 'reply_to' => 
 array (
   'email' => $reply_email,
 ),
 'from' => 
 array (
   'email' => $from,
 ),
 'subject' => $subject,
 'content' => 
 array (
   0 => 
   array (
     'type' => 'text/html',
     'value' => $html,
   ),
 ),
);  
}



  //Send request
  try {  
    $r = new request('https://api.sendgrid.com/v3/mail/send');
    $r->setHeader(array(
      "Authorization: Bearer $this->apiKey",
      "Accept: application/json",
      "Content-Type:application/json"
    ));
    $r->setRawData(json_encode($send_data));

    //Send Request
    $r->request('POST');

    //Process Response

      //If the body is not empty it's probably an error (no body is returned on a success, just a header)
      if ($r->getBody() != '') { 
        $decoded = $r->decode('json'); 
        if ($decoded->error->code != '' || $decoded->errors['0']->message != '') { throw new \Exception("SendGrid Error:" . ' '. $decoded->error->code . ' ' . $decoded->errors['0']->message . ' Field: ' . $decoded->errors['0']->field, 1); };
      } 

      $res_headers = $r->parseHeader();
      $res_header_code = $r->getStatusCode();

      $return = array("body" => $decoded,"header" => $res_headers,"httpCode" => $res_header_code); //No errors so return this.
      //print_r($return);
      return $return;

    } catch (\Exception $e) { $error = $e->getMessage(); throw new \Exception("Request : " . $error); }




} //End send_sendgrid private function.


} //End Class


/*
$additional_parameters = array(
  "reply_to_email" => '',"bcc_email" => '',
    'mailgun' => array("message_id" => '',"o:tracking-clicks" => 'yes',"o:tracking-opens" => 'yes',"o:tag" => '',"v:announcement_id" => '',"v:user_name" => '')
  );
*/