<?php
namespace addie\http;

/*
             _      _  _     __      _      _    _       __                        _                _  _             
            | |    | |(_)    \ \    | |    | |  | |      \ \                      | |              | || |            
   __ _   __| |  __| | _   ___\ \   | |__  | |_ | |_  _ __\ \    ___  ___   _ __  | |_  _ __  ___  | || |  ___  _ __ 
  / _` | / _` | / _` || | / _ \\ \  | '_ \ | __|| __|| '_ \\ \  / __|/ _ \ | '_ \ | __|| '__|/ _ \ | || | / _ \| '__|
 | (_| || (_| || (_| || ||  __/ \ \ | | | || |_ | |_ | |_) |\ \| (__| (_) || | | || |_ | |  | (_) || || ||  __/| |   
  \__,_| \__,_| \__,_||_| \___|  \_\|_| |_| \__| \__|| .__/  \_\\___|\___/ |_| |_| \__||_|   \___/ |_||_| \___||_|   
                                                     | |                                                             
                                                     |_|                                                             

What? The http\controller class is built to help with serving as a front-end controller for serverless app hosting, specifically Google App Engine.
Who? Developed by Don Hawkins
*/

class controller {

public $request;
public $host;
public $ssl;
public $method;
public $return_method;


    public function __construct() {
      $this->request = $_SERVER['REQUEST_URI'];
      $this->host = $_SERVER['HTTP_HOST'];
      $this->ssl = $_SERVER['HTTPS'];
    }

    ## The requested Uri without the query string. 
    private function clean_request() {
      $clean_request = strtok($this->request, '?'); //Remove the query string.
      return $clean_request;
    }

    ## getQuery - Returns the raw query string and the same query string formatted as an array for easy reference.
    public function getQuery() {
      $query_raw = parse_url($this->request, PHP_URL_QUERY); 
      parse_str($query_raw, $query_array);
      $query_return = array('raw' => $query_raw,'neat' => $query_array);
      return $query_return;
    }

    ## getDomain / Gets the current host domain and returns it.
    public function getDomain() {
      return $this->host;
    }

    ## getUri / return the full uri in an object or array
    public function getUri($return_method = 'array') {

        $uri = array();
        $uri = explode('/', $this->clean_request());
        $uri_array_clean = array_filter($uri);

        if ($return_method == 'array') { return $uri_array_clean; }else{ $uri_array_clean = (object)$uri_array_clean; return $uri_array_clean; }

    }

    ## setVariables / Will set variables for values requested in the type that you specify. If they exist, variables will not be overriden. Similar to emulating register_globals from PHP <5. 
    ## We recommend calling this function AFTER 'getUri' to ensure those variables are not overriden. 
    public function setVariables($type = array()) {

      global $_REQUEST;
      global $_GET;
      global $_POST;
      global $_FILES;
  
      //Request
      if (in_array('REQUEST',$type) || in_array('request',$type)) {
        if (!empty($_REQUEST)) {
        foreach ($_REQUEST as $request_key => $this_request_param) {
            if ($this_request_param != '') { global $$request_key; $$request_key = $this_request_param; };
        }
        $key = '';
      }}
  
      //Get
      if (!empty($_GET)) {
      if (in_array('GET',$type) || in_array('get',$type)) {
        foreach ($_GET as $get_key => $this_get_param) {
            if ($this_get_param != '') { global $$get_key; $$get_key = $this_get_param; };
        }
        $key = '';
      }}
  
      //Post
      if (!empty($_POST)) {
      if (in_array('POST',$type) || in_array('post',$type)) {
        foreach ($_POST as $post_key => $this_post_param) {
            if ($this_post_param != '') { global $$post_key; $$post_key = $this_post_param; };
        }
        $key = '';
      }}
  
      //Files
      if (!empty($_FILES)) {
      if (in_array('FILES',$type) || in_array('files',$type)) {
        foreach ($_FILES as $files_key => $this_files_param) {
            if ($this_files_param != '') { global $$files_key; $$files_key = $this_files_param; };
        }
        $key = '';
      }} 
  
  
      return true;
  
    }



    ## serve / If the file exist it will serve (include) the specified file if not return false.
    public function serve($method = 'include') {

      $full_include_path = ''; 
      $this_url_item = '';
      $uri_array_clean = '';
      $uri = '';

      //Loop through each request item and see if one ends in .php
      $uri = explode('/', $this->clean_request());
      $uri_array_clean = array_filter($uri);

      foreach ($uri_array_clean as $this_item) {

        if (strpos($this_item,'.php')) {

          /*
          Since this part of the url contains a .php then we probably want to include a file here, build the include directory relative to the home directory.
          Loop each item AGAIN and build the url until we get to our file ending in .php ($this_item)
          */
          foreach ($uri_array_clean as $this_url_item) {
            if ($this_url_item != '' && $this_url_item != $this_item) { $full_include_path .= '/' . $this_url_item; }
            if ($this_url_item == $this_item) { $full_include_path .= '/' . $this_url_item; }
          }
			
          //Remvoe first slash from string.
          if ($full_include_path != '') { $full_include_path = ltrim($full_include_path, '/'); };

          //If the file exist then try to include it
          if (file_exists($full_include_path)) { 

            $query_string = $this->getQuery(); //Get the query string and convert it to actual variables for the purposes of including the file.
            if (!empty($query_string['neat']) && is_array($query_string['neat'])) { 
              foreach ($query_string['neat'] as $key => $value) {
                $$key = $value;
              }
             }

            if ($method == 'require') { require "$full_include_path";}
            if ($method == 'include') { include "$full_include_path"; }

          }else{
            echo "File not found"; return false;
          }

        }  //End strpos .php
      
      }
    }


} //End Class


/*
TESTING BELOW
*/
/*
$http = new http();
$http->setParams(array('name'=>'Don','last_name'=>'Hawkins'));
echo $http->request('https://yahoo.com','get');


$activate = new http();
$activate->setParams(array('name'=>'Don','last_name'=>'Hawkins'));
$activate->setCreds('username','password');
$res = $activate->request('POST');
*/
?>
