<?php
namespace addie\brokers;
use addie\http\request;
//Chad

/*
   db    8888b.  8888b.  88 888888    dP 88""Yb 88""Yb  dP"Yb  88  dP 888888 88""Yb .dP"Y8    dP 888888 88""Yb    db    8888b.  88 888888 88""Yb 
  dPYb    8I  Yb  8I  Yb 88 88__     dP  88__dP 88__dP dP   Yb 88odP  88__   88__dP `Ybo."   dP    88   88__dP   dPYb    8I  Yb 88 88__   88__dP 
 dP__Yb   8I  dY  8I  dY 88 88""    dP   88""Yb 88"Yb  Yb   dP 88"Yb  88""   88"Yb  o.`Y8b  dP     88   88"Yb   dP__Yb   8I  dY 88 88""   88"Yb  
dP""""Yb 8888Y"  8888Y"  88 888888 dP    88oodP 88  Yb  YbodP  88  Yb 888888 88  Yb 8bodP' dP      88   88  Yb dP""""Yb 8888Y"  88 888888 88  Yb 
*/

$mode = NULL;
$tradier_api_key = NULL;

class tradier {

        public function __construct($mode,$tradier_api_key) {
            $this->mode = $mode;
            $this->tradier_api_key = $tradier_api_key;
        }

/*
         __             __       
   _____/ /_____  _____/ /_______
  / ___/ __/ __ \/ ___/ //_/ ___/
 (__  ) /_/ /_/ / /__/ ,< (__  ) 
/____/\__/\____/\___/_/|_/____/  
                                 
*/

        /* 
        ### markets/lookup (AAPL,[One of the following options: stock, option, etf, index])
            Search for a symbol using the ticker symbol or partial symbol. Results are in descending order by average volume of the security. This can be used for simple search functions.
        */
        public function symbol_lookup($q,$types) {
            if ($q == '') { throw new Exception("'q' must be a symbol or a partial symbol"); }
            if ($types == '') { throw new Exception("'type' must be One or multiple of the following options: stock, option, etf, index"); }
            try { $res = $this->tradier_http('markets/lookup','GET',array("q" => $q,"type" => $types)); return $res; } catch (Exception $e) { $error = $e->getMessage(); throw new Exception($error); }
        }

        /* 
        ### markets/quotes (AAPL,GOOG,MSFT)
            Get a list of symbols using a keyword lookup on the symbols description. Results are in descending order by average volume of the security. This can be used for simple search functions.
        */
        public function get_quotes($symbols) {
            if ($symbols == '') { throw new Exception('No symbols provided'); }
            try { $res = $this->tradier_http('markets/quotes','GET',array("symbols" => $symbols)); return $res; } catch (Exception $e) { $error = $e->getMessage(); throw new Exception($error); }
        }

        /* 
        ### markets/timesales (AAPL*,interval*[One of: tick, 1min, 5min, 15min],start[YYYY-MM-DD HH:MM:SS],end[YYYY-MM-DD HH:MM:SS],session_filter[all or open])
            Get a list of symbols using a keyword lookup on the symbols description. Results are in descending order by average volume of the security. This can be used for simple search functions.
        */
        public function timesales($symbol, $interval, $start, $end, $session_filter) {
            if ($symbol == '') { throw new Exception("'symbol' must be a symbol"); }
            if ($interval == '') { throw new Exception("'interval' must be one of the following options: tick, 1min, 5min, 15min'"); }
            if ($session_filter != '') {
                if ($session_filter != 'all' && $session_filter != 'open') { throw new Exception("If provided, 'session_filter' must be one of the following options: all, open'");
            }
            try { $res = $this->tradier_http('markets/timesales','GET',array("symbol" => $symbol,"interval" => $interval,"start" => $start,"end" => $end,"session_filter" => $session_filter)); return $res; } catch (Exception $e) { $error = $e->getMessage(); throw new Exception($error); }
        }

        /* 
        ### markets/history (AAPL*,start[2019-05-04	],end[2019-05-04])
            Get historical pricing for a security. Will work on options also but NOT EXPIRED OPTIONS. Only returns daily candles. This data will usually cover the entire lifetime of the company if sending reasonable start/end times.
        */
        public function historical($symbol, $interval, $start, $end, $session_filter) {
            if ($symbol == '') { throw new Exception("'symbol' must be a symbol"); }
            try { $res = $this->tradier_http('markets/history','GET',array("symbol" => $symbol,"start" => $start,"end" => $end)); return $res; } catch (Exception $e) { $error = $e->getMessage(); throw new Exception($error); }
        }


/*
         __                            _            
   _____/ /_________  ____ _____ ___  (_)___  ____ _
  / ___/ __/ ___/ _ \/ __ `/ __ `__ \/ / __ \/ __ `/
 (__  ) /_/ /  /  __/ /_/ / / / / / / / / / / /_/ / 
/____/\__/_/   \___/\__,_/_/ /_/ /_/_/_/ /_/\__, /  
                                           /____/   
*/

        /* 
        ### markets/events/session OR accounts/events/session
           Create a session ID number to begin streaming market, nothing is required except to make the call. Will return 
        */
        public function create_streaming_market_session($stream_session_type) {

            if ($stream_session_type == '') { throw new Exception("'stream_session_type' must be one of the following options: 'market' or 'account' : 001"); }
            if ($stream_session_type != 'market' && $stream_session_type != 'account') { throw new Exception("'stream_session_type' must be one of the following options: 'market' or 'account' : 002"); };
            if ($stream_session_type == 'market') { $url = 'markets/events/session'; }else{ $url = 'accounts/events/session'; };
            
            try { $res = $this->tradier_http($url,'POST',''); return $res; } catch (Exception $e) { $error = $e->getMessage(); throw new Exception($error); }
        }





/*
              __  _                 
 ____  ____  / /_(_)___  ____  _____
/ __ \/ __ \/ __/ / __ \/ __ \/ ___/
/ /_/ / /_/ / /_/ / /_/ / / / (__  ) 
\____/ .___/\__/_/\____/_/ /_/____/  
    /_/                              

*/

        /*
        ### markets/options/expirations
            Get expiration dates for a particular underlying stock ($symbol).  Provide true or false for 'include_strikes' to see the strikes for each expiration as well.
        */
        public function get_option_expirations($symbol,$include_strikes) {

            if ($symbol == '') { throw new Exception("'symbol' is expected and required. Provide the underlying symbol."); }
            if ($include_strikes == true || $include_strikes == false) {  }else{ throw new Exception("'include_strikes' must be true or false"); };
            
            try { $res = $this->tradier_http('markets/options/expirations','POST',array("symbol" => $symbol,"strikes" => $include_strikes,"contractSize" => true,"expirationType" => true,"includeAllRoots" => true)); return $res; } catch (Exception $e) { $error = $e->getMessage(); throw new Exception($error); }
        
        }

        /*
        ### markets/options/strikes
            Get strike prices for a specified expiration date (not needed if 'include_strikes' is set to true when calling 'get_option_expirations').
        */
        public function get_option_strikes($symbol,$includeAllRoots) {

            if ($symbol == '') { throw new Exception("'symbol' is expected and required. Provide the underlying symbol."); }
            if ($includeAllRoots == true || $includeAllRoots == false) {  }else{ throw new Exception("'includeAllRoots' must be true or false"); };
            
            try { $res = $this->tradier_http('markets/options/strikes','POST',array("symbol" => $symbol,"includeAllRoot" => $includeAllRoot)); return $res; } catch (Exception $e) { $error = $e->getMessage(); throw new Exception($error); }
        
        }

        /*
        ### markets/options/chains
            Get strike prices for a specified expiration date (not needed if 'include_strikes' is set to true when calling 'get_option_expirations').
        */
        public function get_option_chain($symbol,$expiration,$greeks) {

            if ($symbol == '') { throw new Exception("'symbol' is expected and required. Provide the underlying symbol."); }
            if ($expiration == '') {  }else{ throw new Exception("'expiration' must be provided in YYYY-MM-DD format."); };
            if ($greeks == true || $greeks == false) {  }else{ throw new Exception("'greeks' must be true or false"); };

            try { $res = $this->tradier_http('markets/options/chains','POST',array("symbol" => $symbol,"expiration" => $expiration,"greeks" => $greeks)); return $res; } catch (Exception $e) { $error = $e->getMessage(); throw new Exception($error); }
        
        }






        


        ### Private function to call the Tradier API
        private function tradier_http($service,$method,$params){

            if ($this->$mode == 'test') { $req = new request('https://sandbox.tradier.com/v1/' . $service); };
            if ($this->mode == 'live') { $req = new request('https://api.tradier.com/v1//' . $service); };

            $req->setHeader(array("Authorization: Bearer $this->tradier_api_key","Accept: application/json"));
  
            try {
                if (is_array($params)) { $req->setParams($params); }
                $req->request($method); //Sends the request
            } catch (Exception $e) { $error = $e->getMessage(); throw new Exception($error); }

            $res_obj = $req->decode('json');
            if ($res_obj->error) { throw new Exception($res_obj->error); }
            //$res_body = $req->getBody(); //Full response

            return $res_obj;


        }
}

/*
$test = new tradier('live','feZl0aDalcbi9E8feWQviLjFzWRs');
$return = $test->get_quotes('AAPL,GOOG,MSFT');
print_r($return);
*/
?>
