# addie\auth\loginwith;

A simple class that facilitates authenticating end users with external oauth services including Google, eBay, and others allow you to offer. This class will allow you to offer "Sign In or Sign Up With" buttons on your web application.

## Installation

Refer to main Addie Readme for full install instructions for Addie.

```php
require_once __DIR__ . '/vendor/autoload.php';
use addie\auth\loginwith;
```

## Login With Google

Relies on the 'google/apiclient' package, included as a dependency with Addie.         Steps to integrate "Login with Google" with your web site:

1. Get your Google API client ID by visiting the Google API Console > Credentials > Create credentials > Oauth client ID. When done be sure to save all the credentials, including "Client ID"
2. If you plan to test locally be sure to add http://localhost and http://localhost:<port_number> to the authorize JavaScript orgins.
            NOTE: For localhost testing set the header Referrer-Policy: no-referrer-when-downgrade
3. Next, click "OAuth consent screen" and make sure it's setup for the app you just created. For testing be sure to add "Test Users", & when you're ready to go live click "Publish App".
4. On any page you plan to offer sign in be sure to include the client library.  <script src="https://accounts.google.com/gsi/client" async defer></script>

5. Next, generate the configuration & html button code at the following URL: https://developers.google.com/identity/gsi/web/tools/configurator.

Note : If you plan to get the users contacts be sure to add the contacts scope during app registration ([https://www.googleapis.com/auth/contacts.readonly](https://www.googleapis.com/auth/contacts.readonly))

Note : Once you've created the app registration you'll see the oauth consent screen, click "publish app" button one you're ready to go public.

        $client_id = Your Google API client ID, part of the credentials you'll receive during setup with Google.
        $credential = The auth key, passed as part of the post request from Google after a user clicks the "Login with Google" button.
        $g_csrf_token = Passed as part of the post request from Google after a user clicks the "Login with Google" button.

Example Usage
```php
# When you configure your HTML button (see steps below) point your "Login URI" to the page with the following code:

use addie\auth\loginwith;

try { 

 $login = new loginwith();
 $client_id = 'YOUR GOOGLE API CLIENT ID HERE';
 $verify = $login->google($client_id,$_POST['credential'],$_POST['g_csrf_token']); } catch (Exception $e) { $error = $e->getMessage(); 

    if ($verify === FALSE || $error != '') { 
        //Something went wrong, show user the $error message and redirect to login screen.
        echo "Something went wrong.";
    }else{
        //Login the user here with RecurringStack and set appropiate session valuesf or your app.
        echo "Login the user";
        print_r($verify);
    };

}
```

Example Responce
```php
array(
[iss] => https://accounts.google.com 
[nbf] => 19490303906 
[aud] => 002529055587-pkfrrrf56rom7vn9ahjimc.apps.googleusercontent.com 
[sub] => 3092569074818787154 
[hd] => hawkinstg.com 
[email] => chrish@hawkinstg.com 
[email_verified] => 1 
[azp] => 517817811817-pkl411q9180579f0a56rom7vn9ahjimc.apps.googleusercontent.com 
[name] => Chris Hawkins 
[picture] => https://lh3.googleusercontent.com/a/53tyxmAX3VINEZIuk5dXragLKTNqs44788-c 
[given_name] => Chris
[family_name] => Hawkins 
[iat] => 162399294206 
[exp] => 1684357822306 
[jti] => 74c011bbed5c4c2efd1321fdd1588);
```
## License

[MIT](https://choosealicense.com/licenses/mit/)